/*
 * Decompiled with CFR 0.152.
 */
package pub.pigeon.yggdyy.hexcreating.blocks.board;

import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.item.IotaHolderItem;
import java.util.ArrayList;
import java.util.List;
import kotlin.Triple;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3545;
import org.jetbrains.annotations.Nullable;
import pub.pigeon.yggdyy.hexcreating.blocks.ModBlocks;
import pub.pigeon.yggdyy.hexcreating.blocks.board.AllBoardPasters;
import pub.pigeon.yggdyy.hexcreating.blocks.board.BoardBlock;
import pub.pigeon.yggdyy.hexcreating.blocks.board.BoardBlockEntity;

public class BoardConnected {
    public List<class_2338> blockPoses = new ArrayList<class_2338>(List.of());
    public int condition = 0;
    public class_1937 world;
    public class_2382 x;
    public class_2382 y;
    public class_2680 state;
    public List<Storage<ItemVariant>> storages = new ArrayList<Storage<ItemVariant>>(List.of());
    public List<class_3545<class_2338, Integer>> slots = new ArrayList<class_3545<class_2338, Integer>>(List.of());

    public BoardConnected(class_1937 world, class_2338 pos, class_2680 state) {
        this.world = world;
        this.state = state;
        if (!state.method_27852(ModBlocks.INSTANCE.getBOARD())) {
            return;
        }
        Triple<class_243, class_243, class_243> surface = ((BoardBlock)ModBlocks.INSTANCE.getBOARD()).surface(state, pos);
        this.x = new class_2382((int)((class_243)surface.getSecond()).field_1352, (int)((class_243)surface.getSecond()).field_1351, (int)((class_243)surface.getSecond()).field_1350);
        this.y = new class_2382((int)((class_243)surface.getThird()).field_1352, (int)((class_243)surface.getThird()).field_1351, (int)((class_243)surface.getThird()).field_1350);
        this.dfs(pos);
        this.blockPoses.forEach(blockPos -> {
            for (int i = 0; i < 16; ++i) {
                this.slots.add((class_3545<class_2338, Integer>)new class_3545(blockPos, (Object)i));
            }
            this.condition = Math.max(world.method_49804(blockPos), this.condition);
        });
        this.slots.sort((pair1, pair2) -> {
            class_2338 pos1 = (class_2338)pair1.method_15442();
            class_2338 pos2 = (class_2338)pair2.method_15442();
            int slot1 = (Integer)pair1.method_15441();
            int slot2 = (Integer)pair2.method_15441();
            int i1 = (int)class_243.method_24954((class_2382)pos1).method_1026(class_243.method_24954((class_2382)this.x)) * 4 + slot1 % 4;
            int j1 = (int)class_243.method_24954((class_2382)pos1).method_1026(class_243.method_24954((class_2382)this.y)) * 4 + slot1 / 4;
            int i2 = (int)class_243.method_24954((class_2382)pos2).method_1026(class_243.method_24954((class_2382)this.x)) * 4 + slot2 % 4;
            int j2 = (int)class_243.method_24954((class_2382)pos2).method_1026(class_243.method_24954((class_2382)this.y)) * 4 + slot2 / 4;
            return j1 == j2 ? i1 - i2 : j1 - j2;
        });
    }

    private void dfs(class_2338 pos) {
        if (!this.blockPoses.contains(pos) && this.world.method_8320(pos).method_27852(ModBlocks.INSTANCE.getBOARD()) && ((class_2350)this.world.method_8320(pos).method_11654((class_2769)class_2741.field_12481)).equals((Object)this.state.method_11654((class_2769)class_2741.field_12481))) {
            this.blockPoses.add(pos);
            this.dfs(pos.method_10081(this.x));
            this.dfs(pos.method_10081(this.x.method_35862(-1)));
            this.dfs(pos.method_10081(this.y));
            this.dfs(pos.method_10081(this.y.method_35862(-1)));
        }
    }

    public int getIndex(class_2338 pos, int slot) {
        for (int i = 0; i < this.slots.size(); ++i) {
            if (!((class_2338)this.slots.get(i).method_15442()).equals((Object)pos) || !((Integer)this.slots.get(i).method_15441()).equals(slot)) continue;
            return i;
        }
        return -1;
    }

    @Nullable
    public SlotHandler getSlotHandler(int index) {
        if (index < 0 || index >= this.slots.size()) {
            return null;
        }
        return new SlotHandler(this.world, this.slots.get(index));
    }

    public boolean isEmpty(int index) {
        SlotHandler handler = this.getSlotHandler(index);
        return handler == null || handler.getStack().method_7960();
    }

    @Nullable
    public Section getLeftAndRight(int index) {
        int l;
        if (index < 0 || index >= this.slots.size()) {
            return null;
        }
        int r = index;
        for (l = index; l >= 0 && !this.isEmpty(l); --l) {
        }
        ++l;
        while (r < this.slots.size() && !this.isEmpty(r)) {
            ++r;
        }
        if (l <= --r) {
            return new Section(this, l, r);
        }
        return null;
    }

    @Nullable
    public Section getLeft(int index) {
        int l;
        if (index < 0 || index >= this.slots.size()) {
            return null;
        }
        for (l = index; l >= 0 && !this.isEmpty(l); --l) {
        }
        if (++l <= index) {
            return new Section(this, l, index);
        }
        return null;
    }

    @Nullable
    public Section getRight(int index) {
        int r;
        if (index < 0 || index >= this.slots.size()) {
            return null;
        }
        for (r = index; r < this.slots.size() && !this.isEmpty(r); ++r) {
        }
        if (index <= --r) {
            return new Section(this, index, r);
        }
        return null;
    }

    public void genStorages() {
        if (this.storages.size() == 0) {
            class_2382 _f = this.x.method_10259(this.y);
            class_2350 _d = class_2350.method_50026((int)_f.method_10263(), (int)_f.method_10264(), (int)_f.method_10260()).method_10153();
            for (class_2338 bp : this.blockPoses) {
                class_2338 np = bp.method_10081(_f);
                Storage nowStorage = (Storage)ItemStorage.SIDED.find(this.world, np, (Object)_d);
                if (nowStorage == null) continue;
                this.storages.add((Storage<ItemVariant>)nowStorage);
            }
        }
    }

    public static class SlotHandler {
        public BoardBlockEntity be = null;
        public int slot = 0;

        public SlotHandler(class_1937 world, class_2338 pos, int slot) {
            class_2586 class_25862 = world.method_8321(pos);
            if (class_25862 instanceof BoardBlockEntity) {
                BoardBlockEntity be;
                this.be = be = (BoardBlockEntity)class_25862;
                this.slot = slot;
            }
        }

        public SlotHandler(class_1937 world, class_3545<class_2338, Integer> pair) {
            this(world, (class_2338)pair.method_15442(), (Integer)pair.method_15441());
        }

        public class_1799 getStack() {
            if (this.be == null) {
                return class_1799.field_8037;
            }
            return this.be.method_5438(this.slot);
        }

        public void setStack(class_1799 stack) {
            if (this.be == null) {
                return;
            }
            this.be.method_5447(this.slot, stack);
        }

        public boolean match(AllBoardPasters.IItemStackMatcher matcher) {
            ItemVariant v1 = ItemVariant.of((class_1799)this.be.method_5438(this.slot));
            for (class_3545<class_1799, class_1799> p : matcher.get()) {
                if (!v1.matches((class_1799)p.method_15441())) continue;
                return true;
            }
            return false;
        }
    }

    public static class Section {
        public BoardConnected boards;
        public int l;
        public int r;

        public Section(BoardConnected boards, int l, int r) {
            this.boards = boards;
            if (r < l) {
                int tmp = l;
                l = r;
                r = tmp;
            }
            this.l = Math.max(0, l);
            this.r = Math.min(boards.slots.size() - 1, r);
        }

        public boolean canMoveRight() {
            return this.r + 1 < this.boards.slots.size() && this.boards.isEmpty(this.r + 1);
        }

        public boolean canMoveLeft() {
            return this.l - 1 >= 0 && this.boards.isEmpty(this.l - 1);
        }

        public void moveRight() {
            if (!this.canMoveRight()) {
                return;
            }
            for (int i = this.r + 1; i >= this.l + 1; --i) {
                this.boards.getSlotHandler(i).setStack(this.boards.getSlotHandler(i - 1).getStack());
            }
            this.boards.getSlotHandler(this.l).setStack(class_1799.field_8037);
            ++this.l;
            ++this.r;
        }

        public void moveLeft() {
            if (!this.canMoveLeft()) {
                return;
            }
            for (int i = this.l - 1; i <= this.r - 1; ++i) {
                this.boards.getSlotHandler(i).setStack(this.boards.getSlotHandler(i + 1).getStack());
            }
            this.boards.getSlotHandler(this.r).setStack(class_1799.field_8037);
            --this.l;
            --this.r;
        }

        public List<Iota> getPatterns() {
            ArrayList<Iota> ret = new ArrayList<Iota>(List.of());
            for (int i = this.l; i <= this.r; ++i) {
                IotaHolderItem item;
                Iota iota;
                class_1799 stack;
                class_1792 class_17922;
                if (this.boards.isEmpty(i) || !((class_17922 = (stack = this.boards.getSlotHandler(i).getStack()).method_7909()) instanceof IotaHolderItem) || (iota = (item = (IotaHolderItem)class_17922).readIota(stack, (class_3218)this.boards.world)) == null) continue;
                ret.add(iota);
            }
            return ret;
        }
    }
}

